<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ReporteController extends Controller
{
    public function export(Request $request){
        if ($request->session()->exists('usert')) { 
            $servicios = DB::table('servicios')
            ->join('tecnicos','tecnicos.idtecnico','=','servicios.idtecnico')
            ->join('clientes','clientes.idcliente','=','servicios.idcliente')
            ->select('clientes.*','servicios.*','tecnicos.*') 
            ->orderBy('servicios.id', 'desc')
            ->get();
    
            return view('reporte.export',compact('servicios'));
        }else{
            return redirect('/');
        }
    }
    
    public function index(Request $request)
    { 
        if ($request->session()->exists('usert')) { 
         
            $fechai = request()->fechai;
            $fechaf = request()->fechaf;
   
           //$servicios=  DB::select( DB::raw("SELECT * FROM servicios"));
           $tecnicos=  DB::select( DB::raw("SELECT idtecnico,nombretecnico FROM tecnicos"));
           $clientes=  DB::select( DB::raw("SELECT idcliente,nombrecliente FROM clientes"));
           $filtros=  DB::select( DB::raw("SELECT * FROM filtros"));
   
            
           if($fechai!="" && $fechaf!=""){
               $servicios = DB::table('servicios')
               ->join('tecnicos','tecnicos.idtecnico','=','servicios.idtecnico')
               ->join('clientes','clientes.idcliente','=','servicios.idcliente')
               ->select('clientes.*','servicios.*','tecnicos.*') 
               ->where('servicios.fecha','>=',$fechai)
               ->where('servicios.fecha','<=',$fechaf)
               //->orWhere('factura','!=','Si')
               ->orderBy('servicios.id', 'desc')
               ->get();
       
           }else{
               $servicios = DB::table('servicios')
               ->join('tecnicos','tecnicos.idtecnico','=','servicios.idtecnico')
               ->join('clientes','clientes.idcliente','=','servicios.idcliente')
               ->select('clientes.*','servicios.*','tecnicos.*') 
               ->orderBy('servicios.id', 'desc')
               ->get();
       
   
           }
          
            
           return view('reporte.index',compact('servicios','tecnicos','clientes','filtros','fechai','fechaf'));
        }else{
            return redirect('/');
        }


    }
}
