<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Illuminate\Support\Str;
class ServiciosController extends Controller
{
    //
    public function index(Request $request)
    { 
        if ($request->session()->exists('usert')) { 
            $fechai = request()->fechai;
         $fechaf = request()->fechaf;

        //$servicios=  DB::select( DB::raw("SELECT * FROM servicios"));
        $tecnicos=  DB::select( DB::raw("SELECT idtecnico,nombretecnico FROM tecnicos WHERE activo=1"));
        $clientes=  DB::select( DB::raw("SELECT idcliente,nombrecliente FROM clientes"));
        $filtros=  DB::select( DB::raw("SELECT * FROM filtros"));

        
        if($fechai!="" && $fechaf!=""){
            if(session('perfil')==2){ 
                $servicios = DB::table('servicios')
                ->join('tecnicos','tecnicos.idtecnico','=','servicios.idtecnico')
                ->join('clientes','clientes.idcliente','=','servicios.idcliente')
                ->select('clientes.*','servicios.*','tecnicos.*')  
                ->where('servicios.fecha','>=',$fechai)
                ->where('servicios.fecha','<=',$fechaf) 
                ->where('servicios.idtecnico','=',session('idtecnico'))  
                ->orderBy('clientes.nombrecliente', 'desc')
                ->get();
            }else{
                $servicios = DB::table('servicios')
                ->join('tecnicos','tecnicos.idtecnico','=','servicios.idtecnico')
                ->join('clientes','clientes.idcliente','=','servicios.idcliente')
                ->select('clientes.*','servicios.*','tecnicos.*')  
                ->where('servicios.fecha','>=',$fechai)
                ->where('servicios.fecha','<=',$fechaf)  
                ->orderBy('clientes.nombrecliente', 'desc')
                ->get();
            }
           
    
        }else{
            $fecha_actual = date("Y-m-d");
            if(session('perfil')==2){  
                $servicios = DB::table('servicios')
                ->join('tecnicos','tecnicos.idtecnico','=','servicios.idtecnico')
                ->join('clientes','clientes.idcliente','=','servicios.idcliente')
                ->select('clientes.*','servicios.*','tecnicos.*')
                ->where('servicios.idtecnico','=',session('idtecnico'))  
                ->where('servicios.fecha','>=',$fecha_actual)
                ->where('servicios.fecha','<=',$fecha_actual)  
                //->where('ptto','!=','Si')
                //->orWhere('factura','!=','Si')
                ->orderBy('clientes.nombrecliente', 'desc')
                ->get();
        
            }else{ 
                $servicios = DB::table('servicios')
                ->join('tecnicos','tecnicos.idtecnico','=','servicios.idtecnico')
                ->join('clientes','clientes.idcliente','=','servicios.idcliente')
                ->select('clientes.*','servicios.*','tecnicos.*') 
                //->where('ptto','!=','Si')
                //->orWhere('factura','!=','Si')
                ->orderBy('clientes.nombrecliente', 'desc')
                ->get();
        
            }

            

        }
       
         
        return view('servicios.index',compact('servicios','tecnicos','clientes','filtros'));
        }else{
            return redirect('/');
        }
        
    }
    public function uploadFotos(Request $request){
        $path = "media" ;
       

       
        $arr = [];
        $dir_save=date("Y");
        $path_images_ads=$path; 
        $filesDb="";
        $idservicio ="";
        foreach($request->all() as $file){
            $type= gettype($file);
            switch($type){
                case 'string':
                    $idservicio =$file; 
                    break; 
                case 'object':
                    $random = Str::random(40);
                    $imagesizedata = getimagesize($file);
                    if ($imagesizedata === FALSE){
                    }
                    else
                    {
                        if(is_file($file)){
                            $string =  $dir_save  . date("m").$random;
                            $ext = $file->guessExtension();
                            $file_name = $string . '.' .  $ext;
                            $filepath =  $path_images_ads."/" . $file_name;
                            
                            $file->storeAs(( $path_images_ads), $file_name);
                            
                            
                            $file->move(public_path( $path_images_ads),$filepath);
                            $filesDb .= $file_name."|";
                            array_push($arr, ["file"=>$file_name, "path_file"=>"media/".$file_name]);
                        
                        }
                    }
                        break;
            }
            




        }
        if($idservicio){
            DB::table('servicios')
            ->where('id', $idservicio)
            ->update([
                'fotos'=>$filesDb ,
            ]);
        }
        $arr['m']=  $filesDb;
        $arr['idservicio']=  $idservicio; 
        return response()->json($arr);

    }
    public function eliminar(Request $request){
        if ($request->input('idservicio')) { 
            $r['error']=false;
            $r['mensaje']="eliminado correctamente"; 
            DB::table('servicios')
            ->where('id','=',$request->input('idservicio'))
            ->delete();
         }else{
            
            $r['error']=true;
            $r['mensaje']="Error al eliminarlo"; 
         }
         return $r;
        
     }
    public function actualizar(Request $request){
        date_default_timezone_set('America/Mexico_City');
 
        $fecha_actual = date("Y-m-d h:i:s");
        if ($request->input('idservicio')) { 
            $r['error']=false;
            $r['mensaje']="Actualizado correctamente"; 
            DB::table('servicios')
            ->where('id', $request->input('idservicio'))
            ->update([
                'fecha' => $request->input('e_fecha'),
                'hora' => $request->input('e_hora').":".$request->input('e_tiempo'),
                'idtecnico'=>$request->input('e_idtecnico'),
                'idcliente'=>$request->input('e_idcliente'),
                'servicio'=>$request->input('e_servicio') ,
                'ptto'=>  $request->input('e_ptto') ,
                'factura'=> $request->input('e_factura') ,
                'observaciones'=>'' ,
            ]);

             //$request->session()->exists('usert')
             DB::table('comentarios_servicios')->insert(
                [
                    'tecniconame' =>session('usert'),
                    'comentario' => $request->input('e_observaciones'),
                    'creacion'=> $fecha_actual,
                    'idcsservicio'=>$request->input('idservicio')
                ]
            );
         }else{
            
            $r['error']=true;
            $r['mensaje']="Error al Actualizarlo"; 
         }
         return $r;
        
     }
     public function commentarios(Request $data)
     { 
         
         if($data->input('idservicio')){
             $r['error']=false;
             $r['mensaje']=""; 
             $cliente=DB::table('comentarios_servicios')->where('idcsservicio','=',$data->input('idservicio'))->orderBy('creacion', 'desc')->get();
             
             $r['comentarios']=$cliente; 
             return $r;
         }else{
             $r['error']=true;
             $r['mensaje']="Error en id de cliente";  
             $r['servicio']=""; 
             return $r;
 
         }
      }
    public function get(Request $data)
    { 
        
        if($data->input('idservicio')){
            $r['error']=false;
            $r['mensaje']=""; 
            $cliente=DB::table('servicios')->where('id','=',$data->input('idservicio'))->first();
            
            $r['servicio']=$cliente; 
            return $r;
        }else{
            $r['error']=true;
            $r['mensaje']="Error en id de cliente";  
            $r['servicio']=""; 
            return $r;

        }
     }
    public function nuevo(Request $request)
    {  
        date_default_timezone_set('America/Mexico_City');
 
        $fecha_actual = date("Y-m-d h:i:s");
            $r['error']=false;
            $r['mensaje']="Servicio creado";
            DB::table('servicios')->insert(
                [
                    'fecha' => $request->input('fecha'),
                    'hora' => $request->input('hora').":".$request->input('tiempo'),
                    'idtecnico'=>$request->input('idtecnico'),
                    'idcliente'=>$request->input('idcliente'),
                    'servicio'=>$request->input('servicio') ,
                    'ptto'=>  $request->input('ptto') ,
                    'factura'=> $request->input('factura') ,
                    'observaciones'=>$request->input('observaciones') ,
                ]
            );
             
            $id = DB::getPdo()->lastInsertId();
            $serviciosCreado=DB::table('servicios')->where('id','=',$id)->first();
            $r['servicio']=$serviciosCreado;
            
            //$request->session()->exists('usert')
            DB::table('comentarios_servicios')->insert(
                [
                    'tecniconame' =>session('usert'),
                    'comentario' => $request->input('observaciones'),
                    'creacion'=> $fecha_actual,
                    'idcsservicio'=>$id 
                ]
            );


        return $r;
         
    }
    public function nuevoFiltro(Request $request)
    {   
         
            $r['error']=false;
            $r['mensaje']="Filtro creado";
            DB::table('filtros')->insert(
                [
                    'fechai' => $request->input('fechai'),
                    'fechaf' => $request->input('fechaf')
                ]
            );
             
            $id = DB::getPdo()->lastInsertId();
            $serviciosCreado=DB::table('filtros')->where('idfiltro','=',$id)->first();
            $r['filtro']=$serviciosCreado;
            
        return $r;
         
    }
    public function eliminarFiltro(Request $request){
        if ($request->input('idfiltro')) { 
            $r['error']=false;
            $r['mensaje']="eliminado correctamente"; 
            DB::table('filtros')
            ->where('idfiltro','=',$request->input('idfiltro'))
            ->delete();
         }else{
            
            $r['error']=true;
            $r['mensaje']="Error al eliminarlo"; 
         }
         return $r;
        
     }
}
