<?php

use App\Http\Controllers\ClientesController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\TecnicosController;
use App\Http\Controllers\ServiciosController; 
use App\Http\Controllers\ReporteController;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', [LoginController::class, 'index'])->name('login');
Route::get('/home', [HomeController::class, 'index'])->name('home');

/*Login*/
Route::post('/login', [LoginController::class, 'login'])->name('login.in');

/*REPORTE*/
Route::get('/reporte', [ReporteController::class, 'index'])->name('reporte');
Route::get('/export', [ReporteController::class, 'export'])->name('export');

/*SERVICIOS */
Route::get('/servicios', [ServiciosController::class, 'index'])->name('servicios');
Route::post('/servicios/nuevo', [ServiciosController::class, 'nuevo'])->name('servicios.nuevo');
Route::post('/servicios/get', [ServiciosController::class, 'get'])->name('servicios.get');
Route::post('/servicios/actualizar', [ServiciosController::class, 'actualizar'])->name('servicios.actualizar');
Route::post('/servicios/eliminar', [ServiciosController::class, 'eliminar'])->name('servicios.eliminar');
Route::post('/servicios/fotos', [ServiciosController::class, 'uploadFotos'])->name('servicios.fotos');
Route::post('/servicios/commentarios', [ServiciosController::class, 'commentarios'])->name('servicios.commentarios');


/*SERVICIOS */
Route::post('/servicios/filtros/nuevo', [ServiciosController::class, 'nuevoFiltro'])->name('servicios.filtros.nuevo');
Route::post('/servicios/filtros/eliminar', [ServiciosController::class, 'eliminarFiltro'])->name('servicios.filtros.eliminar');


/*tecnicos */
Route::get('/tecnicos', [TecnicosController::class, 'index'])->name('tecnicos');
Route::post('/tecnicos/nuevo', [TecnicosController::class, 'nuevo'])->name('tecnicos.nuevo');
Route::post('/tecnicos/get', [TecnicosController::class, 'get'])->name('tecnicos.get');
Route::post('/tecnicos/actualizar', [TecnicosController::class, 'actualizar'])->name('tecnicos.actualizar');
Route::post('/tecnicos/eliminar', [TecnicosController::class, 'eliminar'])->name('tecnicos.eliminar');


/*CLIENTES */
Route::get('/clientes', [ClientesController::class, 'index'])->name('clientes');
Route::post('/clientes/nuevo', [ClientesController::class, 'nuevo'])->name('clientes.nuevo');
Route::post('/clientes/get', [ClientesController::class, 'get'])->name('clientes.get');
Route::post('/clientes/actualizar', [ClientesController::class, 'actualizar'])->name('clientes.actualizar');
Route::post('/clientes/eliminar', [ClientesController::class, 'eliminar'])->name('clientes.eliminar');

 
