@extends('templete.layout')

@section('contenido')
<div class="col-12">

  <!-- Header -->
  <div class="header">
    <div class="header-body">
      <div class="row align-items-center">
        <div class="col">

          <!-- Pretitle -->
          <h6 class="header-pretitle">
            Sysme
          </h6>

          <!-- Title -->
          <h1 class="header-title text-truncate">
            Clientes
          </h1>

        </div>
        <div class="col-auto">

          
          <!-- Buttons -->
          <button   class="btn btn-primary ms-2" onclick="sys.cliente.addOpenModel()">
            Agregar cliente
          </a>

        </div>
      </div> <!-- / .row -->
      <div class="row align-items-center">
        <div class="col">

          <!-- Nav -->
          <ul class="nav nav-tabs nav-overflow header-tabs">
            <li class="nav-item">
              <a href="#!" class="nav-link text-nowrap active">
                Todos clientes
              </a>
            </li> 
          </ul>

        </div>
      </div>
    </div>
  </div>

  <!-- Tab content -->
  <div class="tab-content">
    <div class="tab-pane fade show active" id="contactsListPane" role="tabpanel" aria-labelledby="contactsListTab">

      <!-- Card -->
      <div class="card" data-list='{"valueNames": ["item-name", "item-title", "item-email", "item-phone", "item-score", "item-company"], "page": 10, "pagination": {"paginationClass": "list-pagination"}}' id="contactsList">
        <div class="card-header">
          <div class="row align-items-center">
            <div class="col">

              <!-- Form -->
              <form>
                <div class="input-group input-group-flush input-group-merge input-group-reverse">
                  <input class="form-control list-search" type="search" placeholder="Search">
                  <span class="input-group-text">
                    <i class="fe fe-search"></i>
                  </span>
                </div>
              </form>

            </div>
            <div class="col-auto me-n3">

              

            </div>
            <div class="col-auto">

              <!-- Dropdown -->
            
            </div>
          </div> <!-- / .row -->
        </div>
        <div class="table-responsive">
          <table class="table table-sm table-hover table-nowrap card-table">
            <thead>
             
              <tr>
                 
                <th>
                  <a class="list-sort text-muted" data-sort="item-name" href="#">Nombre</a>
                </th>
                <th>
                  <a class="list-sort text-muted" data-sort="item-title" href="#">Direccion</a>
                </th>
                <th>
                  <a class="list-sort text-muted" data-sort="item-score" href="#">RFC</a>
                </th>
                <th>
                  <a class="list-sort text-muted" data-sort="item-email" href="#">Telefono</a>
                </th>
                <th>
                  <a class="list-sort text-muted" data-sort="item-phone" href="#">Celular</a>
                </th>  
                <th>
                  <a class="list-sort text-muted" data-sort="item-company" href="#">Ubicacions</a>
                </th>
                <th>
                   acciones
                </th>
              </tr> 
            </thead>
            <tbody class="list fs-base">
              @foreach($clientes as $cliente)
              <tr>
                
                <td>
                  <span class="item-name">{{$cliente->nombrecliente}}</span>

                </td><td>

                  <!-- Text -->
                  <span class="item-title">{{$cliente->clientedireccion}}</span>

                </td>
                <td>

                  <!-- Text -->
                  <span class="item-title">{{$cliente->rfc}}</span>

                </td>
                <td>

                  <!-- Email -->
                  <a class="item-email text-reset" href="tel:>{{$cliente->clientetelefono}}">{{$cliente->clientetelefono}}</a>

                </td>
                <td>

                  <!-- Phone -->
                  <a class="item-phone text-reset" href="tel:{{$cliente->clientecelular}}">{{$cliente->clientecelular}}</a>

                </td>  
                <td>
                  @if($cliente->googlecurl)
                  <a class="item-company badge bg-success-soft" href="{{$cliente->googlecurl}}" target="_black">Ubicacion</a>
                  @endif
                </td>
                <td class="text-end">
                  <button   class="btn btn-sm btn-white" data-idcliente="{{$cliente->idcliente}}" onclick="sys.cliente.OpenModalEditar(this);">
                    Editar
                  </button>
                  <button   class="btn btn-sm btn-danger" data-idcliente="{{$cliente->idcliente}}" onclick="sys.cliente.ConfirmDelete(this);">
                    Eliminar
                  </button>

                </td>
              </tr>
               @endforeach
            </tbody>
          </table>
        </div>
        <div class="card-footer d-flex justify-content-between">

          <!-- Pagination (prev) -->
          <ul class="list-pagination-prev pagination pagination-tabs card-pagination">
            <li class="page-item">
              <a class="page-link ps-0 pe-4 border-end" href="#">
                <i class="fe fe-arrow-left me-1"></i> Prev
              </a>
            </li>
          </ul>

          <!-- Pagination -->
          <ul class="list-pagination pagination pagination-tabs card-pagination"></ul>

          <!-- Pagination (next) -->
          <ul class="list-pagination-next pagination pagination-tabs card-pagination">
            <li class="page-item">
              <a class="page-link ps-4 pe-0 border-start" href="#">
                Next <i class="fe fe-arrow-right ms-1"></i>
              </a>
            </li>
          </ul>

          <!-- Alert -->
          <div class="list-alert alert alert-dark alert-dismissible border fade" role="alert">

            <!-- Content -->
            <div class="row align-items-center">
              <div class="col">

                <!-- Checkbox -->
                <div class="form-check">
                  <input class="form-check-input" id="listAlertCheckbox" type="checkbox" checked disabled>
                  <label class="form-check-label text-white" for="listAlertCheckbox">
                    <span class="list-alert-count">0</span> deal(s)
                  </label>
                </div>

              </div>
              <div class="col-auto me-n3">

                <!-- Button -->
                <button class="btn btn-sm btn-white-20">
                  Edit
                </button>

                <!-- Button -->
                <button class="btn btn-sm btn-white-20">
                  Delete
                </button>

              </div>
            </div> <!-- / .row -->

            <!-- Close -->
            <button type="button" class="list-alert-close btn-close" aria-label="Close"></button>

          </div>

        </div>
      </div>

    </div>
    <div class="tab-pane fade" id="contactsCardsPane" role="tabpanel" aria-labelledby="contactsCardsTab">

      <!-- Cards -->
      <div data-list='{"valueNames": ["item-name", "item-title", "item-email", "item-phone", "item-score", "item-company"], "page": 9, "pagination": {"paginationClass": "list-pagination"}}' id="contactsCards">

        <!-- Header -->
        <div class="row align-items-center mb-4">
          <div class="col">

            <!-- Form -->
            <form>
              <div class="input-group input-group-lg input-group-merge input-group-reverse">
                <input class="form-control list-search" type="search" placeholder="Search">
                <span class="input-group-text">
                  <i class="fe fe-search"></i>
                </span>
              </div>
            </form>

          </div>
          <div class="col-auto me-n3">

            <!-- Select -->
            <form>
              <select class="form-select form-select-sm form-control-flush" data-choices='{"searchEnabled": false}'>
                <option selected>9 per page</option>
                <option>All</option>
              </select>
            </form>

          </div>
          <div class="col-auto">

            <!-- Dropdown -->
            <div class="dropdown">

              <!-- Toggle -->
              <button class="btn btn-sm btn-white" type="button" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <i class="fe fe-sliders me-1"></i> Filter <span class="badge bg-primary ms-1 d-none">0</span>
              </button>

              <!-- Menu -->
              <form class="dropdown-menu dropdown-menu-end dropdown-menu-card">
                <div class="card-header">

                  <!-- Title -->
                  <h4 class="card-header-title">
                    Filters
                  </h4>

                  <!-- Link -->
                  <button class="btn btn-sm btn-link text-reset d-none" type="reset">
                    <small>Clear filters</small>
                  </button>

                </div>
                <div class="card-body">

                  <!-- List group -->
                  <div class="list-group list-group-flush mt-n4 mb-4">
                    <div class="list-group-item">
                      <div class="row">
                        <div class="col">

                          <!-- Text -->
                          <small>Title</small>

                        </div>
                        <div class="col-auto">

                          <!-- Select -->
                          <select class="form-select form-select-sm" name="item-title" data-choices='{"searchEnabled": false}'>
                            <option value="*" selected>Any</option>
                            <option value="Designer">Designer</option>
                            <option value="Developer">Developer</option>
                            <option value="Owner">Owner</option>
                            <option value="Founder">Founder</option>
                          </select>

                        </div>
                      </div> <!-- / .row -->
                    </div>
                    <div class="list-group-item">
                      <div class="row">
                        <div class="col">

                          <!-- Text -->
                          <small>Lead scrore</small>

                        </div>
                        <div class="col-auto">

                          <!-- Select -->
                          <select class="form-select form-select-sm" name="item-score" data-choices='{"searchEnabled": false}'>
                            <option value="*" selected>Any</option>
                            <option value="1/10">1+</option>
                            <option value="2/10">2+</option>
                            <option value="3/10">3+</option>
                            <option value="4/10">4+</option>
                            <option value="5/10">5+</option>
                            <option value="6/10">6+</option>
                            <option value="7/10">7+</option>
                            <option value="8/10">8+</option>
                            <option value="9/10">9+</option>
                            <option value="10/10">10</option>
                          </select>

                        </div>
                      </div> <!-- / .row -->
                    </div>
                  </div>

                  <!-- Button -->
                  <button class="btn w-100 btn-primary" type="submit">
                    Apply filter
                  </button>

                </div>
              </form>

            </div>

          </div>
        </div> <!-- / .row -->

        <!-- Body -->
        <div class="list row">
         
          <div class="col-12 col-md-6 col-xl-4">

            <!-- Card -->
            <div class="card">
              <div class="card-body">

                <!-- Header -->
                <div class="row align-items-center">
                  <div class="col">

                    <!-- Checkbox -->
                    <div class="form-check form-check-circle">
                      <input class="form-check-input list-checkbox" type="checkbox" id="cardsCheckboxOne">
                      <label class="form-check-label" for="cardsCheckboxOne"></label>
                    </div>

                  </div>
                  <div class="col-auto">

                    <!-- Dropdown -->
                    <div class="dropdown">
                      <a href="#" class="dropdown-ellipses dropdown-toggle" role="button" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="fe fe-more-vertical"></i>
                      </a>
                      <div class="dropdown-menu dropdown-menu-end">
                        <a href="#!" class="dropdown-item">
                          Action
                        </a>
                        <a href="#!" class="dropdown-item">
                          Another action
                        </a>
                        <a href="#!" class="dropdown-item">
                          Something else here
                        </a>
                      </div>
                    </div>

                  </div>
                </div> <!-- / .row -->

                <!-- Image -->
                <a href="profile-posts.html" class="avatar avatar-xl card-avatar">
                  <img src="assets/img/avatars/profiles/avatar-1.jpg" class="avatar-img rounded-circle" alt="...">
                </a>

                <!-- Body -->
                <div class="text-center mb-5">

                 
                  <!-- Buttons -->
                  <a class="btn btn-sm btn-white" href="tel:1-123-456-7890">
                    <i class="fe fe-phone me-1"></i> Call
                  </a>
                  <a class="btn btn-sm btn-white" href="mailto:john.doe@company.com">
                    <i class="fe fe-mail me-1"></i> Email
                  </a>

                </div>

                <!-- Divider -->
                <hr class="card-divider mb-0">

                <!-- List group -->
                <div class="list-group list-group-flush mb-n3">
                  <div class="list-group-item">
                    <div class="row">
                      <div class="col">

                        <!-- Text -->
                        <small>Company</small>

                      </div>
                      <div class="col-auto">

                        <!-- Text -->
                        <small>Twitter</small>

                      </div>
                    </div> <!-- / .row -->
                  </div>
                  <div class="list-group-item">
                    <div class="row">
                      <div class="col">

                        <!-- Text -->
                        <small>Lead Score</small>

                      </div>
                      <div class="col-auto">

                        <!-- Badge -->
                        <span class="item-score badge bg-danger-soft">1/10</span>

                      </div>
                    </div> <!-- / .row -->
                  </div>
                </div>

              </div>
            </div>

          </div> 
        </div>

        <!-- Pagination -->
        <div class="row g-0">

          <!-- Pagination (prev) -->
          <ul class="col list-pagination-prev pagination pagination-tabs justify-content-start">
            <li class="page-item">
              <a class="page-link" href="#">
                <i class="fe fe-arrow-left me-1"></i> Prev
              </a>
            </li>
          </ul>

          <!-- Pagination -->
          <ul class="col list-pagination pagination pagination-tabs justify-content-center"></ul>

          <!-- Pagination (next) -->
          <ul class="col list-pagination-next pagination pagination-tabs justify-content-end">
            <li class="page-item">
              <a class="page-link" href="#">
                Next <i class="fe fe-arrow-right ms-1"></i>
              </a>
            </li>
          </ul>

        </div>

        <!-- Alert -->
        <div class="list-alert alert alert-dark alert-dismissible border fade" role="alert">

          <!-- Content -->
          <div class="row align-items-center">
            <div class="col">

              <!-- Checkbox -->
              <div class="form-check">
                <input class="form-check-input" id="cardAlertCheckbox" type="checkbox" checked disabled>
                <label class="form-check-label text-white" for="cardAlertCheckbox">
                  <span class="list-alert-count">0</span> deal(s)
                </label>
              </div>

            </div>
            <div class="col-auto me-n3">

              <!-- Button -->
              <button class="btn btn-sm btn-white-20">
                Edit
              </button>

              <!-- Button -->
              <button class="btn btn-sm btn-white-20">
                Delete
              </button>

            </div>
          </div> <!-- / .row -->

          <!-- Close -->
          <button type="button" class="list-alert-close btn-close" aria-label="Close">

          </button>

        </div>

      </div>

    </div>
  </div>

</div>

  <!-- modal-->  
  <div class="modal fade" id="clienteNuevo" aria-hidden="true" aria-labelledby="exampleModalToggleLabel" tabindex="-1">
    <div class="modal-dialog modal-lg ">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title" id="exampleModalToggleLabel">CLIENTE 😀</h4>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <div>
            <div class="card-body p-2"> 
              <!-- Form -->
              <form name="crearCliente">
                <div class="form-group mb-2">
                  <label for="nombre" class="form-label">Nombre comercial</label>
                  <input type="text" class="form-control" name="nombre" id="nombre" placeholder="Enter email">
                </div>
                <div class="form-group mb-2">
                  <label for="nombre" class="form-label">RFC:</label>
                  <input type="text" class="form-control" name="rfc" id="rfc" placeholder="XAXX010101000 ">
                </div>
                <div class="form-group mb-2">
                  <label for="nombre" class="form-label">Dirección</label> 
                  <textarea class="form-control" name="direccion" id="direccion" rows="3"></textarea> 
                </div> 
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group mb-2">
                      <label for="nombre" class="form-label">Teléfono </label>
                      <input type="text" class="form-control" name="telefono" id="telefono" placeholder="3312701862">
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group mb-2">
                      <label for="nombre" class="form-label">Celular</label>
                      <input type="text" class="form-control" name="celular" id="celular" placeholder="3312701862">
                    </div>
                  </div>
                </div> 
                <div class="form-group mb-4" style="display: none">
                  <label for="nombre" class="form-label">Correo electronico</label>
                  <input type="text" class="form-control" name="email" id="email" placeholder="codigonan@gmail.com">
                </div> 
                <div class="form-group mb-2">
                  <label for="nombre" class="form-label">Url google ubicacion</label>
                  <input type="text" class="form-control" name="googlecurl" id="googlecurl" placeholder="https://goo.gl/maps/n4LstMvnYk9myNCG9">
                </div>
                <button type="submit" class="btn btn-primary">Guardar</button> 
              </form>
            </div>
          </div>
        </div>
         <div class="modal-footer">
          <button class="btn btn-danger" data-bs-dismiss="modal">Cerrar</button>
        </div>  
      </div>
    </div>
  </div>
   <!-- modal-->  
   <div class="modal fade" id="clienteEditar" aria-hidden="true" aria-labelledby="exampleModalToggleLabel" tabindex="-1">
    <div class="modal-dialog modal-lg ">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title" id="exampleModalToggleLabel">EDITAR CLIENTE 😀</h4>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <div>
            <div class="card-body p-2"> 
              <!-- Form -->
              <form name="editarCliente">
                <div class="form-group mb-2">
                  <label for="nombre" class="form-label">Nombre comercial</label>
                  <input type="text" class="form-control" name="e_nombre" id="e_nombre" placeholder="Enter email">
                </div>
                <div class="form-group mb-2">
                  <label for="nombre" class="form-label">RFC:</label>
                  <input type="text" class="form-control" name="e_rfc" id="e_rfc" placeholder="XAXX010101000 ">
                </div>
                <div class="form-group mb-2">
                  <label for="nombre" class="form-label">Dirección</label> 
                  <textarea class="form-control" name="e_direccion" id="e_direccion" rows="3"></textarea> 
                </div> 
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group mb-2">
                      <label for="nombre" class="form-label">Teléfono </label>
                      <input type="text" class="form-control" name="e_telefono" id="e_telefono" placeholder="3312701862">
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group mb-2">
                      <label for="nombre" class="form-label">Celular</label>
                      <input type="text" class="form-control" name="e_celular" id="e_celular" placeholder="3312701862">
                    </div>
                  </div>
                </div> 
                <div class="form-group mb-4">
                  <label for="nombre" class="form-label">Correo electronico</label>
                  <input type="text" class="form-control" name="e_email" id="e_email" placeholder="codigonan@gmail.com">
                </div> 
                
                <div class="form-group mb-2">
                  <label for="nombre" class="form-label">Url google ubicacion</label>
                  <input type="text" class="form-control" name="e_googlecurl" id="e_googlecurl" placeholder="https://goo.gl/maps/n4LstMvnYk9myNCG9">
                </div>
                <button type="submit" class="btn btn-primary">Guardar</button> 
              </form>
            </div>
          </div>
        </div>
         <div class="modal-footer">
          <button class="btn btn-danger" data-bs-dismiss="modal">Cerrar</button>
        </div>  
      </div>
    </div>
  </div>
 
 @endsection
@section('scripts') 
<script> 
sys.cliente.crear();
</script>
@endsection