<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ReporteController extends Controller
{
    public function export(Request $request){
        if ($request->session()->exists('usert')) { 
            $servicios = DB::table('servicios')
            ->join('tecnicos','tecnicos.idtecnico','=','servicios.idtecnico')
            ->join('clientes','clientes.idcliente','=','servicios.idcliente')
            ->select('clientes.*','servicios.*','tecnicos.*') 
            ->orderBy('servicios.id', 'desc')
            ->get();
    
            return view('reporte.export',compact('servicios'));
        }else{
            return redirect('/');
        }
    }
    
    public function index(Request $request)
    { 
        if ($request->session()->exists('usert')) { 
         
            $fechai = request()->fechai;
            $fechaf = request()->fechaf;
            $ptto = request()->ptto;
   
           //$servicios=  DB::select( DB::raw("SELECT * FROM servicios"));
           $tecnicos=  DB::select( DB::raw("SELECT idtecnico,nombretecnico FROM tecnicos"));
           $clientes=  DB::select( DB::raw("SELECT idcliente,nombrecliente FROM clientes"));
           $filtros=  DB::select( DB::raw("SELECT * FROM filtros"));
   
            
           if($fechai!="" && $fechaf!=""){
               switch ($ptto) {
                case 0: //TODO
                     $servicios = DB::table('servicios')
                       ->join('tecnicos','tecnicos.idtecnico','=','servicios.idtecnico')
                       ->join('clientes','clientes.idcliente','=','servicios.idcliente')
                       ->select('clientes.*','servicios.*','tecnicos.*') 
                       ->where('servicios.fecha','>=',$fechai)
                       ->where('servicios.fecha','<=',$fechaf)
                       //->orWhere('factura','!=','Si')
                       ->orderBy('servicios.id', 'desc')
                       ->get();
                    break;
                case 1: //Si|No
                     $servicios = DB::table('servicios')
                       ->join('tecnicos','tecnicos.idtecnico','=','servicios.idtecnico')
                       ->join('clientes','clientes.idcliente','=','servicios.idcliente')
                       ->select('clientes.*','servicios.*','tecnicos.*') 
                       ->where('servicios.fecha','>=',$fechai)
                       ->where('servicios.fecha','<=',$fechaf) 
                       ->where('servicios.ptto','=',"Si") 
                       ->where('servicios.factura','=',"No") 
                       ->orderBy('servicios.id', 'desc')
                       ->get();
                    break;
                case 2:  //Si|Si
                     $servicios = DB::table('servicios')
                       ->join('tecnicos','tecnicos.idtecnico','=','servicios.idtecnico')
                       ->join('clientes','clientes.idcliente','=','servicios.idcliente')
                       ->select('clientes.*','servicios.*','tecnicos.*') 
                       ->where('servicios.fecha','>=',$fechai)
                       ->where('servicios.fecha','<=',$fechaf) 
                       ->where('servicios.ptto','=',"Si") 
                       ->where('servicios.factura','=',"Si") 
                       ->orderBy('servicios.id', 'desc')
                       ->get();
                    break;
                case 3:  //No|No
                     $servicios = DB::table('servicios')
                       ->join('tecnicos','tecnicos.idtecnico','=','servicios.idtecnico')
                       ->join('clientes','clientes.idcliente','=','servicios.idcliente')
                       ->select('clientes.*','servicios.*','tecnicos.*') 
                       ->where('servicios.fecha','>=',$fechai)
                       ->where('servicios.fecha','<=',$fechaf) 
                       ->where('servicios.ptto','=',"No") 
                       ->where('servicios.factura','=',"No") 
                       ->orderBy('servicios.id', 'desc')
                       ->get();
                    break;
                case 4:  //No|si
                     $servicios = DB::table('servicios')
                       ->join('tecnicos','tecnicos.idtecnico','=','servicios.idtecnico')
                       ->join('clientes','clientes.idcliente','=','servicios.idcliente')
                       ->select('clientes.*','servicios.*','tecnicos.*') 
                       ->where('servicios.fecha','>=',$fechai)
                       ->where('servicios.fecha','<=',$fechaf) 
                       ->where('servicios.ptto','=',"No") 
                       ->where('servicios.factura','=',"Si") 
                       ->orderBy('servicios.id', 'desc')
                       ->get();
                    break;
            }
              
       
           }else{
               $servicios = DB::table('servicios')
               ->join('tecnicos','tecnicos.idtecnico','=','servicios.idtecnico')
               ->join('clientes','clientes.idcliente','=','servicios.idcliente')
               ->select('clientes.*','servicios.*','tecnicos.*') 
               ->orderBy('servicios.id', 'desc')
               ->get();
       
   
           }
          
            
           return view('reporte.index',compact('servicios','tecnicos','clientes','filtros','fechai','fechaf','ptto'));
        }else{
            return redirect('/');
        }


    }
}
